<?php

require_once __DIR__ . '/catchexception.php';
// include db connect class
require_once __DIR__ . '/db_config.php';
// array for JSON response
$response = array();
$branchcode = ($_GET['branchcode']);
$billdate = ($_GET['billdate']);
date_default_timezone_set('Asia/Kolkata');

try{
if ($branchcode != "" && $billdate != "") {
    $paraquery = "SELECT voucherno,transactiondate,coalesce(CAST((basicamount) AS DECIMAL(1000, 2)),0)  as gross_sales_amount,coalesce(CAST((netamount) AS DECIMAL(1000, 2)),0)  as netamount,salestime,coalesce(CAST((discamount) AS DECIMAL(1000, 2)),0) as discount,coalesce(customermobileno,'') as mobilenumber,coalesce(customername,'') as customername,coalesce(cgstamount,0) as cgst,coalesce(sgstamount,0) as sgst from tblsales where branchcode = $branchcode and to_char(to_timestamp(transactiondate/1000),'dd-mm-yyyy') = '$billdate' order by voucherno desc" ;
    $result = pg_query($con, $paraquery);
    if (!empty($result)) {
        if (pg_num_rows($result) > 0) {
            // user node
            $response["Value"] = array();
        
            while ($row = pg_fetch_assoc($result)) {
                $mil = $row["transactiondate"];
                $seconds = ($mil / 1000);
                $tax = $row["sgst"] + $row["cgst"];
                $grand_total =$row["netamount"] - $tax;
                $report = array();
                $report["store_id"] = 1;
                $report["till_id"] = 1;
                $report["voucherno"] = $row["voucherno"];
                $report["transactiondate"] = date("d/m/Y",$seconds);
                $report["payable_amount"] = $row["netamount"];
                $report["salestime"] = $row["salestime"];
                $report["discount"] = $row["discount"];
                $report["mobilenumber"] = $row["mobilenumber"];
                $report["customername"] = $row["customername"];
                $report["tax_amount"] = sprintf('%0.2f', $tax);
                $report["exc_taxable_amount"] = $row["gross_sales_amount"];
                $report["salestype"] = 'sales';
                $report["payment"] = $row["netamount"];

                // push single product into final response array
                array_push($response["Value"], $report);
            }
            // success
            $response["success"] = 1;

            // echoing JSON response
            echo json_encode($response, JSON_UNESCAPED_SLASHES);
        } else {
            // no user found
            $response["success"] = 0;
            $response["message"] = "No Report found";

            // echo no users JSON
            echo json_encode($response);
        }
    } else {
        // no user found
        $response["success"] = 0;
        $response["message"] = "No found";

        // echo no users JSON
        echo json_encode($response);
    }
} else {
    // required field is missing
    $response["success"] = 0;
    $response["message"] = "Required field(s) is missing";

    echo json_encode($response, JSON_UNESCAPED_UNICODE);
}
pg_close($con);
}
//catch exception
catch(Exception $e) {
pg_close($con);
echo 'Message: ' .$e->getMessage();
}
?>