<?php

require_once __DIR__ . '/catchexception.php';
// include db connect class
require_once __DIR__ . '/db_config.php';
// array for JSON response
$response = array();
$branchcode = ($_GET['branchcode']);
$billdate = ($_GET['billdate']);
date_default_timezone_set('Asia/Kolkata');

try{
if ($branchcode != "" && $billdate != "") {
    $paraquery = "SELECT voucherno,transactiondate,coalesce(CAST((netamount) AS DECIMAL(1000, 2)),0)  as netamount,salestime,coalesce(customermobileno,'') as mobilenumber,coalesce(customername,'') as customername,coalesce(cgstamount,0) as cgst,coalesce(sgstamount,0) as sgst,cashamount,creditamount,onlineamount,onlineorders from tblsales where branchcode = $branchcode and to_char(to_timestamp(transactiondate/1000),'dd-mm-yyyy') = '$billdate' " ;
    $result = pg_query($con, $paraquery);
    if (!empty($result)) {
        if (pg_num_rows($result) > 0) {
            // user node
            $response["Value"] = array();

            while ($row = pg_fetch_assoc($result)) {
                $tax = $row["sgst"] + $row["cgst"];
                $paymenttype = "";
                $mil = $row["transactiondate"];
                $seconds = ($mil / 1000);
                if($row["cashamount"] > 0 && $row["creditamount"] > 0 && $row["onlineamount"] > 0)  $paymenttype = "Cash,Card,Online";
                else if($row["cashamount"] > 0 && $row["creditamount"] > 0) $paymenttype = "Cash,Card";
                else if($row["cashamount"] > 0 && $row["onlineamount"] > 0)  $paymenttype = "Cash,Online";
                else if($row["creditamount"] > 0 && $row["onlineamount"] > 0)  $paymenttype = "Card,Online";
                else if($row["creditamount"] > 0 )  $paymenttype = "Card";
                else if($row["cashamount"] > 0 )  $paymenttype = "Cash";
                else if($row["onlineamount"] > 0 )  $paymenttype = "Online";
                else if( $row["cashamount"] == 0 && $row["creditamount"] == 0 && $row["onlineamount"] == 0 )  $paymenttype = "Online Orders";
                else  $paymenttype = "";
                $report = array();
                $report["LOCATION_CODE"] = 01;
                $report["TERMINAL_ID"] = 01;
                $report["SHIFT_NO"] = 01;
                $report["REPT_NUM"] = $row["voucherno"];
                $report["REPT_DT"] = date("d-m-Y", $seconds);
                $report["BUSINESS_DT"] = date("d-m-Y", $seconds);
                $report["REPT_TM"] = $row["salestime"];
                $report["INV_AMT"] = $row["netamount"];
                $report["TAX_AMT"] = sprintf('%0.2f', $tax);
                $report["RET_AMT"] = 0;
                $report["PAYMENT_NAME"] = $paymenttype;
                $report["CURRENCY_CODE"] ="INR";
                $report["EXCHANGE_RATE"] = 0;
                $report["TENDER_AMOUNT"] = $row["netamount"];
                $report["PAYMENT_STATUS"] = 'sales';

                // push single product into final response array
                array_push($response["Value"], $report);
            }
            // success
            $response["success"] = 1;

            // echoing JSON response
            echo json_encode($response, JSON_UNESCAPED_UNICODE);
        } else {
            // no user found
            $response["success"] = 0;
            $response["message"] = "No Report found";

            // echo no users JSON
            echo json_encode($response);
        }
    } else {
        // no user found
        $response["success"] = 0;
        $response["message"] = "No found";

        // echo no users JSON
        echo json_encode($response);
    }
} else {
    // required field is missing
    $response["success"] = 0;
    $response["message"] = "Required field(s) is missing";

    echo json_encode($response, JSON_UNESCAPED_UNICODE);
}
pg_close($con);
}
//catch exception
catch(Exception $e) {
pg_close($con);
echo 'Message: ' .$e->getMessage();
}
?>